<?php
	require_once('../helper/conn.php');
	require_once('../model/response.php');
	require_once('../helper/message.php');
	require_once('../helper/utils.php');
	require_once('sender.php');

	try {
		$writeDB = DB::connectionWriteDB();
		$readDB = DB::connectionReadDB();
	} catch (PDOException $ex) {
		error_log("Connection Error - ".$ex, 0);
		sendResponse(500,false,"Database Connection Error: ".$ex);
	}

	$method = $_SERVER['REQUEST_METHOD'];

	if(!isset($_SERVER['CONTENT_TYPE']) || $_SERVER['CONTENT_TYPE'] !== 'application/json') {
		sendResponse(400,false,"Content type header is not JSON");
	}

	$rawPOSTData = file_get_contents('php://input');

	if (!$jsonData = json_decode($rawPOSTData)) {
		sendResponse(400,false,"Request body is not JSON");
	}

	$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
	$uriSegments = explode('/', rtrim($uri, '/'));
	$action = end($uriSegments);

	if ($method === 'POST') {
		if ($action == 'request_help') {
			if (
				!isset($jsonData->concern) || 
				!isset($jsonData->createdBy) || 
				!isset($jsonData->requestedTo) || 
				!isset($jsonData->userLat) || 
				!isset($jsonData->userLng)
			) {
				sendResponse(400, false, "Incomplete data submitted");
			}

			$concern     = $jsonData->concern;
			$createdBy   = $jsonData->createdBy;
			$requestedTo = $jsonData->requestedTo;
			$userLat     = $jsonData->userLat;
			$userLng     = $jsonData->userLng;
			$dateCreated = getCurrentDateAndTime();

			if ($concern === '') {
			    sendResponse(400, false, "Please fill in all required field");
			}

			$qryInsertRequest = $writeDB->prepare("
		        INSERT INTO tbl_request (
		            concern, createdBy, requestedTo, userLat, userLng, dateCreated
		        ) VALUES (
		            :concern, :createdBy, :requestedTo, :userLat, :userLng, :dateCreated
		        )
		    ");
		    $qryInsertRequest->bindParam(':concern', $concern, PDO::PARAM_STR);
		    $qryInsertRequest->bindParam(':createdBy', $createdBy, PDO::PARAM_INT);
		    $qryInsertRequest->bindParam(':requestedTo', $requestedTo, PDO::PARAM_INT);
		    $qryInsertRequest->bindParam(':userLat', $userLat, PDO::PARAM_STR);
		    $qryInsertRequest->bindParam(':userLng', $userLng, PDO::PARAM_STR);
		    $qryInsertRequest->bindParam(':dateCreated', $dateCreated, PDO::PARAM_STR);
		    $qryInsertRequest->execute();

		    if ($qryInsertRequest->rowCount() === 0) {
			    sendResponse(400, false, "Unable to send request. Please try again later.");
			}

			$query = $writeDB->prepare("SELECT fcmToken FROM tbl_users WHERE id = :id");
			$query->bindParam(':id', $requestedTo, PDO::PARAM_INT);
			$query->execute();

			if ($query->rowCount() > 0) {
			    $row = $query->fetch(PDO::FETCH_ASSOC);
			    $fcmToken = $row['fcmToken'];

			    if (!empty($fcmToken)) {
			        list($success, $message) = sendPushNotification($fcmToken, "Mechanic Needed", "Someone requested a service in your mechanic shop. Open the app to see the details",$requestedTo);
			        
			        if ($success) {
			        	sendResponse(200,true,"Request has been sent. Please wait for the confirmation of the mechanic");
			        } else {
			        	sendResponse(400,false,"There was an issue notifying the shop although we submitted your request. Try call or text the owner");
			        }
			    } else {
			    	sendResponse(200,true,"Request has been sent but we couldnt notify the shop. Try call or text the owner");
			    }
			}
		}

		if ($action == 'check_help') {
			if (
				!isset($jsonData->createdBy) || 
				!isset($jsonData->requestedTo) 
			) {
				sendResponse(400, false, "Incomplete data submitted");
			}

			$createdBy   = $jsonData->createdBy;
			$requestedTo = $jsonData->requestedTo;
			$dateCreated = getCurrentDateAndTime();
			$showRequest = true; 
			$message     = "";
			$status      = "";
			$requestId  = 0;

			$query = $writeDB->prepare("SELECT * FROM tbl_request WHERE createdBy = :createdBy AND requestedTo = :requestedTo AND DATE(dateCreated) = DATE(:dateCreated) ORDER BY dateCreated DESC LIMIT 1");
			$query->bindParam(':createdBy', $createdBy, PDO::PARAM_INT);
			$query->bindParam(':requestedTo', $requestedTo, PDO::PARAM_INT);
			$query->bindParam(':dateCreated', $dateCreated, PDO::PARAM_STR);
			$query->execute();

			if ($query->rowCount() > 0) {
				$row         = $query->fetch(PDO::FETCH_ASSOC);
				$status      = $row["status"];
				$requestId   = $row["id"];

				if ($status == "Pending") {
					$showRequest = false;
					$message = "Please wait to accept by the mechanic";
				} else if ($status == "Accepted") {
					$showRequest = false;
					$message = "Mechanic accepted your request. Kindly wait for it to be completed";
				}
			}

			$returnData = array();
			$returnData["show_request"] = $showRequest;
			$returnData["message"]      = $message;
			$returnData["status"]       = $status;
			$returnData["requestId"]    = $requestId;

			sendResponse(200,true,null,$returnData);
		}

		if ($action == "cancel_request") {
			if (
				!isset($jsonData->requestId) || 
				!isset($jsonData->shopId) 
			) {
				sendResponse(400, false, "Incomplete data submitted");
			}

			$requestId   = $jsonData->requestId;
			$shopId      = $jsonData->shopId;
			$dateUpdated = getCurrentDateAndTime();

			$query = $writeDB->prepare("SELECT * FROM tbl_request WHERE id = :id");
			$query->bindParam(':id', $requestId, PDO::PARAM_INT);
			$query->execute();

			if ($query->rowCount() > 0) {
				$row         = $query->fetch(PDO::FETCH_ASSOC);
				$status      = $row["status"];

				if ($status == "Accepted") {
					sendResponse(400,false,"Your request has been accepted by the mechanic. You can contact the mechanic directly to cancel");
				} else if ($status == "Pending") {
					$qryUpdateRequest = $writeDB->prepare("UPDATE tbl_request SET `status` = 'Cancelled',dateUpdated = :dateUpdated WHERE id = :id");
					$qryUpdateRequest->bindParam(':dateUpdated', $dateUpdated, PDO::PARAM_STR);
				    $qryUpdateRequest->bindParam(':id', $requestId, PDO::PARAM_INT);
				    $qryUpdateRequest->execute();

				    if ($qryUpdateRequest->rowCount() === 0) {
					    sendResponse(400, false, "Unable to cancel request. Please try again later.");
					}

					$query = $writeDB->prepare("SELECT fcmToken FROM tbl_users WHERE id = :id");
					$query->bindParam(':id', $shopId, PDO::PARAM_INT);
					$query->execute();

					if ($query->rowCount() > 0) {
					    $row = $query->fetch(PDO::FETCH_ASSOC);
					    $fcmToken = $row['fcmToken'];

					    if (!empty($fcmToken)) {
					        list($success, $message) = sendPushNotification($fcmToken, "Request Cancelled", "Sorry to inform you but the customer cancelled the request",$shopId);
					        
					        if ($success) {
					        	sendResponse(200,true,"Request Cancellation has been sent.");
					        } else {
					        	sendResponse(400,false,"There was an issue notifying the shop although we submitted your cancellation request. Try call or text the owner");
					        }
					    } else {
					    	sendResponse(200,true,"Cancellation request has been sent but we couldnt notify the shop. Try call or text the owner");
					    }
					}
				} else {
					sendResponse(400,false,"Unable to cancel as it is already completed");
				}
			}
		}


		if ($action == "accept_request") {
			if (
				!isset($jsonData->requestId)
			) {
				sendResponse(400, false, "Incomplete data submitted");
			}

			$requestId   = $jsonData->requestId;
			$dateUpdated = getCurrentDateAndTime();

			$query = $writeDB->prepare("SELECT * FROM tbl_request WHERE id = :id");
			$query->bindParam(':id', $requestId, PDO::PARAM_INT);
			$query->execute();

			if ($query->rowCount() > 0) {
				$row         = $query->fetch(PDO::FETCH_ASSOC);
				$status      = $row["status"];
				$createdBy   = $row["createdBy"];

				if ($status == "Cancelled") {
					sendResponse(400,false,"Unable to accept because the customer cancelled the request");
				} else if ($status == "Pending") {
					$qryUpdateRequest = $writeDB->prepare("UPDATE tbl_request SET `status` = 'Accepted',dateUpdated = :dateUpdated WHERE id = :id");
					$qryUpdateRequest->bindParam(':dateUpdated', $dateUpdated, PDO::PARAM_STR);
				    $qryUpdateRequest->bindParam(':id', $requestId, PDO::PARAM_INT);
				    $qryUpdateRequest->execute();

				    if ($qryUpdateRequest->rowCount() === 0) {
					    sendResponse(400, false, "Unable to accept request. Please try again later.");
					}

					$query = $writeDB->prepare("SELECT fcmToken FROM tbl_users WHERE id = :id");
					$query->bindParam(':id', $createdBy, PDO::PARAM_INT);
					$query->execute();

					if ($query->rowCount() > 0) {
					    $row = $query->fetch(PDO::FETCH_ASSOC);
					    $fcmToken = $row['fcmToken'];

					    if (!empty($fcmToken)) {
					        list($success, $message) = sendPushNotification($fcmToken, "Request Accepted", "Congratulations! The mechanic accepted your request. Open the app to view the details",$createdBy);
					        
					        if ($success) {
					        	sendResponse(200,true,"We informed the customer that you accepted the request.");
					        } else {
					        	sendResponse(200,false,"There was an issue notifying the customer although we submitted your acceptance request. Try call or text the customer");
					        }
					    } else {
					    	sendResponse(200,true,"Acceptance request has been sent but we couldnt notify the customer. Try call or text the customer");
					    }
					}
				} else {
					sendResponse(400,false,"Unable to accept. It is already ongoing");
				}
			}
		}

		if ($action == "decline_request") {
			if (
				!isset($jsonData->requestId)
			) {
				sendResponse(400, false, "Incomplete data submitted");
			}

			$requestId   = $jsonData->requestId;
			$dateUpdated = getCurrentDateAndTime();

			$query = $writeDB->prepare("SELECT * FROM tbl_request WHERE id = :id");
			$query->bindParam(':id', $requestId, PDO::PARAM_INT);
			$query->execute();

			if ($query->rowCount() > 0) {
				$row         = $query->fetch(PDO::FETCH_ASSOC);
				$status      = $row["status"];
				$createdBy   = $row["createdBy"];

				if ($status == "Cancelled") {
					sendResponse(400,false,"Unable to decline because the customer cancelled the request");
				} else if ($status == "Pending" || $status == "Accepted") {
					$qryUpdateRequest = $writeDB->prepare("UPDATE tbl_request SET `status` = 'Declined',dateUpdated = :dateUpdated WHERE id = :id");
					$qryUpdateRequest->bindParam(':dateUpdated', $dateUpdated, PDO::PARAM_STR);
				    $qryUpdateRequest->bindParam(':id', $requestId, PDO::PARAM_INT);
				    $qryUpdateRequest->execute();

				    if ($qryUpdateRequest->rowCount() === 0) {
					    sendResponse(400, false, "Unable to decline request. Please try again later.");
					}

					$query = $writeDB->prepare("SELECT fcmToken FROM tbl_users WHERE id = :id");
					$query->bindParam(':id', $createdBy, PDO::PARAM_INT);
					$query->execute();

					if ($query->rowCount() > 0) {
					    $row = $query->fetch(PDO::FETCH_ASSOC);
					    $fcmToken = $row['fcmToken'];

					    if (!empty($fcmToken)) {
					        list($success, $message) = sendPushNotification($fcmToken, "Request Declined", "Sorry to inform you that the mechanic declined your request",$createdBy);
					        
					        if ($success) {
					        	sendResponse(200,true,"We informed the customer that you declined the request.");
					        } else {
					        	sendResponse(200,false,"There was an issue notifying the customer although we submitted your declined request. Try call or text the customer");
					        }
					    } else {
					    	sendResponse(200,true,"Declined request has been sent but we couldnt notify the customer. Try call or text the customer");
					    }
					}
				} else {
					sendResponse(400,false,"Unable to decline request");
				}
			}
		}

		if ($action == "complete_request") {
			if (
				!isset($jsonData->requestId)
			) {
				sendResponse(400, false, "Incomplete data submitted");
			}

			$requestId   = $jsonData->requestId;
			$dateUpdated = getCurrentDateAndTime();

			$query = $writeDB->prepare("SELECT * FROM tbl_request WHERE id = :id");
			$query->bindParam(':id', $requestId, PDO::PARAM_INT);
			$query->execute();

			if ($query->rowCount() > 0) {
				$row         = $query->fetch(PDO::FETCH_ASSOC);
				$status      = $row["status"];
				$createdBy   = $row["createdBy"];

				$qryUpdateRequest = $writeDB->prepare("UPDATE tbl_request SET `status` = 'Completed',dateUpdated = :dateUpdated WHERE id = :id");
				$qryUpdateRequest->bindParam(':dateUpdated', $dateUpdated, PDO::PARAM_STR);
			    $qryUpdateRequest->bindParam(':id', $requestId, PDO::PARAM_INT);
			    $qryUpdateRequest->execute();

			    if ($qryUpdateRequest->rowCount() === 0) {
				    sendResponse(400, false, "Unable to complete request. Please try again later.");
				}

				$query = $writeDB->prepare("SELECT fcmToken FROM tbl_users WHERE id = :id");
				$query->bindParam(':id', $createdBy, PDO::PARAM_INT);
				$query->execute();

				if ($query->rowCount() > 0) {
				    $row = $query->fetch(PDO::FETCH_ASSOC);
				    $fcmToken = $row['fcmToken'];

				    if (!empty($fcmToken)) {
				        list($success, $message) = sendPushNotification($fcmToken, "Request Completed", "Congratulations as your request has been completed. Were happy to serve you",$createdBy);
				        
				        if ($success) {
				        	sendResponse(200,true,"We informed the customer that you completed the request.");
				        } else {
				        	sendResponse(200,false,"There was an issue notifying the customer although we submitted your completed request. Try call or text the customer");
				        }
				    } else {
				    	sendResponse(200,true,"Completed request has been sent but we couldnt notify the customer. Try call or text the customer");
				    }
				}
			}
		}

		if ($action == "get_requests") {
		    if (!isset($jsonData->requestedTo)) {
		        sendResponse(400, false, "Incomplete data submitted");
		    }

		    $requestedTo = $jsonData->requestedTo;

		    $queryGetRequests = $readDB->prepare("
		        SELECT 
		            a.id,
		            a.concern,
		            a.userLat,
		            a.userLng,
		            a.status,
		            CONCAT(b.lastName, ', ', b.firstName, ' ', IFNULL(b.middleName, '')) AS fullName,
		            b.mobileNumber,
		            a.dateCreated,
		            b.id AS userId
		        FROM tbl_request a
		        INNER JOIN tbl_users b ON a.createdBy = b.id
		        WHERE a.requestedTo = :requestedTo
		        ORDER BY a.dateCreated DESC
		    ");

		    $queryGetRequests->bindParam(':requestedTo', $requestedTo, PDO::PARAM_INT);
		    $queryGetRequests->execute();
		    $requests = $queryGetRequests->fetchAll(PDO::FETCH_ASSOC);

		    $requestArray = array();

		    foreach ($requests as $request) {
		        $requestArray[] = array(
		            "id"           => $request["id"],
		            "concern"      => $request["concern"],
		            "userLat"      => $request["userLat"],
		            "userLng"      => $request["userLng"],
		            "status"       => $request["status"],
		            "fullName"     => $request["fullName"],
		            "mobileNumber" => $request["mobileNumber"],
		            "dateCreated"  => formatTimeAgo($request["dateCreated"]),
		            "imageLink"    => getImageLink('person',$request["userId"])
		        );
		    }

		    $returnData = array(
		        "rows_returned" => count($requestArray),
		        "requests"      => $requestArray
		    );

		    sendResponse(200, true, null, $returnData);
		}



		sendResponse(400,false,"Action not found");
	}		


	sendResponse(400,false,"Endpoint not found");
?>