<?php
	require_once('../helper/conn.php');
	require_once('../model/response.php');
	require_once('../helper/message.php');
	require_once('../helper/utils.php');
	require_once('sender.php');

	try {
		$writeDB = DB::connectionWriteDB();
		$readDB = DB::connectionReadDB();
	} catch (PDOException $ex) {
		error_log("Connection Error - ".$ex, 0);
		sendResponse(500,false,"Database Connection Error: ".$ex);
	}

	$method = $_SERVER['REQUEST_METHOD'];

	if(!isset($_SERVER['CONTENT_TYPE']) || $_SERVER['CONTENT_TYPE'] !== 'application/json') {
		sendResponse(400,false,"Content type header is not JSON");
	}

	$rawPOSTData = file_get_contents('php://input');

	if (!$jsonData = json_decode($rawPOSTData)) {
		sendResponse(400,false,"Request body is not JSON");
	}

	$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
	$uriSegments = explode('/', rtrim($uri, '/'));
	$action = end($uriSegments);


	if ($method === 'POST') {
		if ($action == "new_service") {  
			if (
				!isset($jsonData->userId) ||
				!isset($jsonData->service) || 
				!isset($jsonData->description) || 
				!isset($jsonData->base64)
			) {
				sendResponse(400,false,"Incomplete data submitted");
			}

			$userId      = $jsonData->userId;
			$service     = $jsonData->service;
			$description = $jsonData->description;
			$base64      = trim($jsonData->base64);
			$dateCreated = getCurrentDateAndTime();

			if ($service == '' || $description == '' || $base64 == '') {
				sendResponse(400,false,"Please fill in all required fields");
			}

			$queryCheck = $writeDB->prepare("SELECT * FROM tbl_service WHERE service = :service AND isActive = 1 AND createdBy = :createdBy");
			$queryCheck->bindParam(':service',$service,PDO::PARAM_STR);
			$queryCheck->bindParam(':createdBy',$userId,PDO::PARAM_INT);
			$queryCheck->execute();

			if ($queryCheck->rowCount() !== 0) {
				sendResponse(400,false,"Service already exist");
			}

			$queryInsert = $writeDB->prepare("
		        INSERT INTO tbl_service (
		        	service,
		        	description,
		        	createdBy,
		        	dateCreated
		        ) VALUES (
		        	:service,
		        	:description,
		        	:createdBy,
		        	:dateCreated
		        )
		    ");

		    $queryInsert->bindParam(':service', $service, PDO::PARAM_STR);
		    $queryInsert->bindParam(':description', $description, PDO::PARAM_STR);
		    $queryInsert->bindParam(':createdBy', $userId, PDO::PARAM_INT);
		    $queryInsert->bindParam(':dateCreated', $dateCreated, PDO::PARAM_STR);
		    $queryInsert->execute();

		    if ($queryInsert->rowCount() === 0) {
			    sendResponse(400, false, "Failed to register service.");
			}

			$lastInsertedId = $writeDB->lastInsertId();
			$serviceDir     = "../images/service/". $lastInsertedId;

			if (!saveBase64Image($base64, $serviceDir)) {
				$queryDelete = $writeDB->prepare("
					UPDATE tbl_service
					SET isActive = 0
					WHERE id = :serviceId AND createdBy = :userId AND isActive = 1
				");

				$queryDelete->bindParam(':serviceId', $lastInsertedId, PDO::PARAM_INT);
				$queryDelete->bindParam(':userId', $userId, PDO::PARAM_INT);
				$queryDelete->execute();

				sendResponse(400, false, "Failed to register service.");
			}

		    sendResponse(200, true, "Shop details added successfully");
		}

		if ($action == "update_service") {
			if (
				!isset($jsonData->userId) ||
				!isset($jsonData->serviceId) ||
				!isset($jsonData->oldService) ||
				!isset($jsonData->service) ||
				!isset($jsonData->description)
			) {
				sendResponse(400, false, "Incomplete data submitted");
			}

			$userId      = $jsonData->userId;
			$serviceId   = $jsonData->serviceId;
			$oldService  = $jsonData->oldService;
			$service     = $jsonData->service;
			$description = $jsonData->description;
			$base64      = isset($jsonData->base64) ? trim($jsonData->base64) : '';

			if ($service == '' || $description == '') {
				sendResponse(400,false,"Please fill in all required fields");
			}

			if ($oldService !== $service) {
				$queryCheck = $readDB->prepare("
					SELECT * FROM tbl_service 
					WHERE service = :service 
					AND isActive = 1 
					AND createdBy = :createdBy 
					AND id != :serviceId
				");
				$queryCheck->bindParam(':service', $service, PDO::PARAM_STR);
				$queryCheck->bindParam(':createdBy', $userId, PDO::PARAM_INT);
				$queryCheck->bindParam(':serviceId', $serviceId, PDO::PARAM_INT);
				$queryCheck->execute();

				if ($queryCheck->rowCount() !== 0) {
					sendResponse(400, false, "A service with the new name already exists");
				}
			}

			if ($base64 != '') {
				$serviceDir = "../images/service/". $serviceId;

				if (!saveBase64Image($base64, $serviceDir)) {
					sendResponse(400, false, "Unable proceed in updating service because it fails to upload the picture. Please try again later");
				}
			}

			$queryUpdate = $writeDB->prepare("
				UPDATE tbl_service
				SET service = :service,
					description = :description
				WHERE id = :serviceId
			");

			$queryUpdate->bindParam(':service', $service, PDO::PARAM_STR);
			$queryUpdate->bindParam(':description', $description, PDO::PARAM_STR);
			$queryUpdate->bindParam(':serviceId', $serviceId, PDO::PARAM_INT);
			$queryUpdate->execute();

			sendResponse(200, true, "Service updated successfully");
		}

		if ($action == "delete_service") {
			if (
				!isset($jsonData->userId) ||
				!isset($jsonData->serviceId)
			) {
				sendResponse(400, false, "Incomplete data submitted");
			}

			$userId    = $jsonData->userId;
			$serviceId = $jsonData->serviceId;

			$queryDelete = $writeDB->prepare("
				UPDATE tbl_service
				SET isActive = 0
				WHERE id = :serviceId AND createdBy = :userId AND isActive = 1
			");

			$queryDelete->bindParam(':serviceId', $serviceId, PDO::PARAM_INT);
			$queryDelete->bindParam(':userId', $userId, PDO::PARAM_INT);
			$queryDelete->execute();

			if ($queryDelete->rowCount() === 0) {
				sendResponse(400, false, "Service not found or already deleted");
			}

			sendResponse(200, true, "Service deleted successfully");
		}

		if ($action == "get_services") {
			if (!isset($jsonData->userId)) {
				sendResponse(400, false, "Incomplete data submitted");
			}

			$userId = $jsonData->userId;
			$search = isset($jsonData->search) ? $jsonData->search : '';

			if ($search === '') {
				$queryGetServices = $readDB->prepare("
					SELECT id, service, description, dateCreated
					FROM tbl_service
					WHERE isActive = 1 AND createdBy = :userId
					ORDER BY dateCreated DESC
				");
				$queryGetServices->bindParam(':userId', $userId, PDO::PARAM_INT);
			} else {
				$queryGetServices = $readDB->prepare("
					SELECT id, service, description, dateCreated
					FROM tbl_service
					WHERE isActive = 1 
					AND createdBy = :userId 
					AND service LIKE :search
					ORDER BY dateCreated DESC
				");
				$likeSearch = "%{$search}%";
				$queryGetServices->bindParam(':userId', $userId, PDO::PARAM_INT);
				$queryGetServices->bindParam(':search', $likeSearch, PDO::PARAM_STR);
			}

			$queryGetServices->execute();
			$services = $queryGetServices->fetchAll(PDO::FETCH_ASSOC);

			$serviceArray = array();

			foreach ($services as $service) {
				$serviceArray[] = array(
					"id"          => $service["id"],
					"service"     => $service["service"],
					"description" => $service["description"],
					"dateCreated" => $service["dateCreated"],
					"imageLink"   => getImageLink('service',$service["id"])
				);
			}

			$returnData = array(
				"rows_returned" => count($serviceArray),
				"services"      => $serviceArray
			);

			sendResponse(200, true, null, $returnData);
		}

		if ($action == "get_tools") {
		    $search = isset($jsonData->search) ? $jsonData->search : '';

		    if ($search === '') {
		        $queryGetTools = $readDB->prepare("
		            SELECT id, tool, description, dateCreated
		            FROM tbl_tools
		            WHERE isActive = 1
		            ORDER BY dateCreated DESC
		        ");
		    } else {
		        $queryGetTools = $readDB->prepare("
		            SELECT id, tool, description, dateCreated
		            FROM tbl_tools
		            WHERE isActive = 1
		            AND tool LIKE :search
		            ORDER BY dateCreated DESC
		        ");
		        $likeSearch = "%{$search}%";
		        $queryGetTools->bindParam(':search', $likeSearch, PDO::PARAM_STR);
		    }

		    $queryGetTools->execute();
		    $tools = $queryGetTools->fetchAll(PDO::FETCH_ASSOC);

		    $toolArray = array();

		    foreach ($tools as $tool) {
		        $toolArray[] = array(
		            "id"          => $tool["id"],
		            "tool"        => $tool["tool"],
		            "description" => $tool["description"],
		            "dateCreated" => $tool["dateCreated"],
		            "imageLink"   => getImageLinkWeb('tools', $tool["id"]) 
		        );
		    }

		    $returnData = array(
		        "rows_returned" => count($toolArray),
		        "tools"         => $toolArray
		    );

		    sendResponse(200, true, null, $returnData);
		}

		if ($action == "get_videos") {
		    $search = isset($jsonData->search) ? $jsonData->search : '';

		    if ($search === '') {
		        $queryGetVideos = $readDB->prepare("
		            SELECT id, link, title, dateCreated
		            FROM tbl_videos
		            WHERE isActive = 1
		            ORDER BY dateCreated DESC
		        ");
		    } else {
		        $queryGetVideos = $readDB->prepare("
		            SELECT id, link, title, dateCreated
		            FROM tbl_videos
		            WHERE isActive = 1
		            AND title LIKE :search
		            ORDER BY dateCreated DESC
		        ");
		        $likeSearch = "%{$search}%";
		        $queryGetVideos->bindParam(':search', $likeSearch, PDO::PARAM_STR);
		    }

		    $queryGetVideos->execute();
		    $videos = $queryGetVideos->fetchAll(PDO::FETCH_ASSOC);

		    $videoArray = array();

		    foreach ($videos as $video) {
		        $videoArray[] = array(
		            "id"          => $video["id"],
		            "link"        => $video["link"],
		            "title"       => $video["title"],
		            "dateCreated" => $video["dateCreated"]
		        );
		    }

		    $returnData = array(
		        "rows_returned" => count($videoArray),
		        "videos"        => $videoArray
		    );

		    sendResponse(200, true, null, $returnData);
		}


		sendResponse(400,false,"Action not found");
	}

	sendResponse(400,false,"Endpoint not found");
?>