<?php
    /*
        Check if there is an exisiting conversation 
        between the sender and receiver and if none 
        then create one
    */
    function getChatIdWithCreation($senderId,$receiverId,$currentDateTime) {
        global $writeDB;

        $queryCheckExistingChatId = $writeDB->prepare("
            SELECT 
                a.chatId
            FROM
                t_message_details a 
            WHERE
                (a.senderId = :senderId_1 AND a.receiverId = :receiverId_1) 
            OR 
                (a.senderId = :receiverId_2 AND a.receiverId = :senderId_2)
            LIMIT 1
        ");

        $queryCheckExistingChatId->bindValue(':senderId_1', $senderId, PDO::PARAM_INT);
        $queryCheckExistingChatId->bindValue(':senderId_2', $senderId, PDO::PARAM_INT);
        $queryCheckExistingChatId->bindValue(':receiverId_1', $receiverId, PDO::PARAM_INT);
        $queryCheckExistingChatId->bindValue(':receiverId_2', $receiverId, PDO::PARAM_INT);
        $queryCheckExistingChatId->execute();
        $rowCount = $queryCheckExistingChatId->rowCount();

        if ($rowCount === 0) {
            $chatId = getApplicationId();

            $queryInsertMessageHeader = $writeDB->prepare("
                INSERT INTO t_message_header 
                    (chatId,lastModified)
                VALUES
                    (:chatId,:lastModified)
            ");
            $queryInsertMessageHeader->bindParam(':chatId',$chatId,PDO::PARAM_STR);
            $queryInsertMessageHeader->bindParam(':lastModified',$currentDateTime,PDO::PARAM_STR);
            $queryInsertMessageHeader->execute();
            
            $rowCount = $queryInsertMessageHeader->rowCount();

            if ($rowCount === 0) {
                sendResponse(400,false,"Something went wrong. Please try again later");
            }
        } else {
            $row    = $queryCheckExistingChatId->fetch(PDO::FETCH_ASSOC);
            $chatId = $row["chatId"];

            usleep(500000);

            $queryUpdateMessageHeader = $writeDB->prepare("
                UPDATE t_message_header SET lastModified = :lastModified WHERE chatId = :chatId
            ");
            $queryUpdateMessageHeader->bindParam(':lastModified',$currentDateTime,PDO::PARAM_STR);
            $queryUpdateMessageHeader->bindParam(':chatId',$chatId,PDO::PARAM_STR);
            $queryUpdateMessageHeader->execute();
            
            $rowCount = $queryUpdateMessageHeader->rowCount();

            if ($rowCount === 0) {
                sendResponse(400,false,"Something went wrong. Please try again later");
            }
        }

        return $chatId;
    }

    /* 
        Get already existing chat id
    */
    function getAlreadyExistingChatId($senderId,$receiverId) {
        global $writeDB;

        $queryCheckExistingChatId = $writeDB->prepare("
            SELECT 
                a.chatId
            FROM
                t_message_details a 
            WHERE
                (a.senderId = :senderId_1 AND a.receiverId = :receiverId_1) 
            OR 
                (a.senderId = :receiverId_2 AND a.receiverId = :senderId_2)
            LIMIT 1
        ");

        $queryCheckExistingChatId->bindValue(':senderId_1', $senderId, PDO::PARAM_INT);
        $queryCheckExistingChatId->bindValue(':senderId_2', $senderId, PDO::PARAM_INT);
        $queryCheckExistingChatId->bindValue(':receiverId_1', $receiverId, PDO::PARAM_INT);
        $queryCheckExistingChatId->bindValue(':receiverId_2', $receiverId, PDO::PARAM_INT);
        $queryCheckExistingChatId->execute();

        $row = $queryCheckExistingChatId->fetch(PDO::FETCH_ASSOC);

        if (!$row) {
            return null;
        }

        return $row["chatId"];
    }

    /*
        Get the full name
    */
    function getName($userId) {
        global $writeDB;

        $queryGetName = $writeDB->prepare("
            SELECT 
                CONCAT(a.lastName,', ',a.firstName,' ',IFNULL(a.middleName,'')) AS fullName
            FROM
                t_registration a 
            WHERE
                id = :id
        ");
        $queryGetName->bindParam(':id',$userId,PDO::PARAM_INT);
        $queryGetName->execute();
        $rowCount = $queryGetName->rowCount();

        if ($rowCount === 0) {
            sendResponse(400,false,"Something went wrong. Please try again later");
        }

        $row      = $queryGetName->fetch(PDO::FETCH_ASSOC);
        $fullName = $row["fullName"];

        return $fullName;
    }

    /*
        Get the profile pic
    */
    function getProfilePic($userId) {
        global $writeDB;

        $queryGetProfile = $writeDB->prepare("
            SELECT 
                a.hasProfile,
                a.applicationId
            FROM
                t_registration a 
            WHERE
                id = :id
        ");
        $queryGetProfile->bindParam(':id',$userId,PDO::PARAM_INT);
        $queryGetProfile->execute();
        $rowCount = $queryGetProfile->rowCount();

        $row           = $queryGetProfile->fetch(PDO::FETCH_ASSOC);
        $hasProfile    = $row["hasProfile"];
        $applicationId = $row["applicationId"];

        if ($hasProfile === 1) {
            return getDomainURL() . "/sampa-api/pictures/" . $applicationId . "/profile.png";
        } else {
            return "-";
        }
    }

    /*
        Get all unread message id
    */
    function getAllUnreadMessageId($chatId,$userId) {
        global $writeDB;
        $unreadChatId = array();

        $queryGetChatId = $writeDB->prepare("
            SELECT id FROM t_message_details WHERE chatId = :chatId AND isRead = 0 AND senderId != :senderId
        ");
        $queryGetChatId->bindParam(':chatId',$chatId,PDO::PARAM_STR);
        $queryGetChatId->bindParam(':senderId',$userId,PDO::PARAM_INT);
        $queryGetChatId->execute();
        
        while ($row = $queryGetChatId->fetch(PDO::FETCH_ASSOC)) {
            $currentUnreadChatId = array("id" => $row["id"]);

            $unreadChatId[] = $currentUnreadChatId;
        }

        return $unreadChatId;
    }
?>