<?php
    date_default_timezone_set('Asia/Manila');

    function validateEmail(string $email): bool {
        return preg_match('/^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,}$/', $email);
    }

    function isValidUsername($username) {
        return preg_match('/^[a-zA-Z0-9]+$/', $username) === 1;
    }


    function isPureNumber($value) {
        return ctype_digit($value);
    }

    function getDomainURL() {
        $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https://" : "http://";
        return $current_url = $protocol . $_SERVER['HTTP_HOST'];
    }

    function getCurrentDateAndTime() {
        return date('Y-m-d H:i:s', time());
    }

    function getApplicationId() {
        return date('YmdHis', time());
    }

    function getCurrentYear() {
        return date('Y', time());
    }

    function getImageLink($subfolder,$fileName) {
        return 'https://pags-hq.com/mekanikogo-api/images/'.$subfolder.'/'.$fileName.'.png?random='.getApplicationId();
    }

    function getImageLinkWeb($subfolder,$fileName) {
        return 'https://pags-hq.com/mekanikogo-admin/photos/'.$subfolder.'/'.$fileName.'.png?random='.getApplicationId();
    }

    function formatTimeAgo($dateString) {
        $timestamp = strtotime($dateString);
        $currentTimestamp = time();
        $difference = $currentTimestamp - $timestamp;
        
        $intervals = array(
            array('year', 31536000),
            array('month', 2592000),
            array('week', 604800),
            array('day', 86400),
            array('hour', 3600),
            array('minute', 60),
            array('second', 1)
        );
        
        foreach ($intervals as $interval) {
            $unit = $interval[0];
            $seconds = $interval[1];
            if ($difference >= $seconds) {
                $value = floor($difference / $seconds);
                $output = $value . ' ' . $unit;
                if ($value > 1) {
                    $output .= 's';
                }
                $output .= ' ago';
                return $output;
            }
        }
        
        return 'Just now';
    }

    function saveBase64Image($base64String, $filePath) {
        if (empty($base64String)) {
            return false;
        }

        $filePath = pathinfo($filePath, PATHINFO_DIRNAME) . '/' . pathinfo($filePath, PATHINFO_FILENAME) . '.png';
        $base64String = preg_replace('/^data:image\/\w+;base64,/', '', $base64String);
        $imageData = base64_decode($base64String);
        
        if (!$imageData) {
            return false;
        }

        $image = @imagecreatefromstring($imageData);

        if (!$image) {
            return false;
        }

        $result = imagepng($image, $filePath);
        imagedestroy($image);

        return $result && file_exists($filePath) && filesize($filePath) > 0;
    }

    function convertToNull($value) {
        return (is_null($value) || trim((string)$value) === '') ? null : $value;
    }

    function removeValue($value,$toRemove) {
        return str_replace($toRemove, "", $value);
    }

    function formatPHP($number) {
        if (fmod($number, 1) == 0.0) {
            return number_format((int)$number);
        }
    
        return number_format($number, 2, '.', ',');
    }

    function generateRandomCode($length = 10) {
        $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $index = random_int(0, strlen($characters) - 1);
            $randomString .= $characters[$index];
        }
        return $randomString;
    }
?>
